within PVSystems.Electrical;
model SW1 "Switched model implemented with switch + diode"
  extends Interfaces.SwitchNetworkInterface;
  Modelica.Electrical.Analog.Ideal.IdealClosingSwitch sw1(Ron=Ron) annotation (
      Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=270,
        origin={-40,0})));
  Modelica.Electrical.Analog.Ideal.IdealDiode sw2(Ron=RD, Vknee=VD) annotation (
     Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={40,0})));
  Control.SwitchingPWM signalPWM(
    dMax=dMax,
    dMin=dMin,
    fs=fs,
    startTime=startTime) annotation (Placement(transformation(
        extent={{10,10},{-10,-10}},
        rotation=270,
        origin={0,-70})));
  parameter Real dMax=1 "Maximum duty cycle";
  parameter Real dMin=0 "Minimum duty cycle";
  parameter Modelica.SIunits.Frequency fs "Switching frequency";
  parameter Modelica.SIunits.Time startTime=0 "Start time";
  parameter Modelica.SIunits.Resistance RD=1.E-5
    "Forward state-on differential resistance (closed resistance)";
  parameter Modelica.SIunits.Voltage VD=0 "Forward threshold voltage";
  parameter Modelica.SIunits.Resistance Ron=1.E-5 "Closed switch resistance";
equation
  connect(p1, sw1.p)
    annotation (Line(points={{-100,50},{-40,50},{-40,10}}, color={0,0,255}));
  connect(n1, sw1.n) annotation (Line(points={{-100,-50},{-40,-50},{-40,-10}},
        color={0,0,255}));
  connect(sw2.n, p2) annotation (Line(points={{40,10},{40,10},{40,50},{100,50}},
        color={0,0,255}));
  connect(n2, sw2.p)
    annotation (Line(points={{100,-50},{40,-50},{40,-10}}, color={0,0,255}));
  connect(signalPWM.vc, d)
    annotation (Line(points={{0,-82},{0,-120},{0,-120}}, color={0,0,127}));
  connect(signalPWM.c1, sw1.control) annotation (Line(points={{2.22045e-015,-59},
          {0,-59},{0,-1.33227e-015},{-33,-1.33227e-015}}, color={255,0,255}));
  annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)));
end SW1;
